
import Utilities.gui_creator as gc
import Utilities.mccdaq_operations as mo
import threading
import time

board_num, counter_num = 0, 0

root = gc.create_window(title='Frequency Meter',
                        size='300x100')

lbl_2 = gc.create_indicator(root,
                            label_1='Frequency (Hz)')

def acquire_sample():

    while btn.cget('text') == 'Stop':
        mo.clear_counter (board_num, counter_num)
        time.sleep(1.0)
        count = mo.read_counter(board_num, counter_num)
        string_data = str(count)

        lbl_2.config(text=string_data)

    return

def toggle():

    if btn.cget('text') == 'Start':
        btn.config(text='Stop')
    elif btn.cget('text') == 'Stop':
        btn.config(text='Start')

    t = threading.Thread(target=acquire_sample)
    t.start()

    return


btn = gc.action_button(root, label='Start', action=toggle)

root.mainloop()
